<?php

namespace App\Contracts;

/**
 * Interface RegionParserContract
 * @package App\Contracts
 */
interface RegionParserContract
{
    /**
     * Get all regions available.
     *
     * @return \Illuminate\Support\Collection
     */
    public function getRegions();

    /**
     * Parse all districts by region `alias`.
     *
     * @param $region
     * @return \Illuminate\Support\Collection
     */
    public function parseRegion($region);

    /**
     * Parse all cities by district URL.
     *
     * @param string $url
     * @param $district
     * @return \Illuminate\Support\Collection
     */
    public function parseDistrict(string $url, $district);

    /**
     * Parse one city.
     *
     * @param string $url
     * @param $city
     * @return mixed
     */
    public function parseCity(string $url, $city);

}
