<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\CityRepository;

/**
 * Class HomeController
 * @package App\Http\Controllers
 */
class HomeController extends Controller
{
    public function index()
    {
        return view('home');
    }

    public function search(Request $request, CityRepository $cityRepository)
    {
        $search = $request->get('search');

        $result = $cityRepository->searchBy('name', '%'. $search. '%', 'LIKE');

        return response()->json($result);

    }

    public function city(Request $request, CityRepository $cityRepository)
    {
        $city = $cityRepository->getBy('name', $request->get('search'));
        return view('city', ['city' => $city]);

    }

}
