<?php


namespace App\Services\Regions\Jobs;

use App\Contracts\RegionParserContract;
use Illuminate\Bus\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

/**
 * Class ParseRegionDistricts
 * @package App\Services\Regions\Jobs
 */
class ParseRegionDistricts
{
    use Dispatchable, InteractsWithQueue, SerializesModels, Queueable;

    /**
     * @var \App\Contracts\RegionParserContract $service
     */
    private $service;

    /**
     * @var \App\Models\Regions\Region
     */
    private $region;

    /**
     * ParseRegionDistricts constructor.
     *
     * @param \App\Contracts\RegionParserContract $service
     * @param \App\Models\Regions\Region $region
     */
    public function __construct(RegionParserContract $service, $region)
    {
        $this->service = $service;
        $this->region = $region;
    }

    /**
     * Parse districts.
     */
    public function handle(): void
    {
        $this->service->parseRegion($this->region)->each(function ($item, $url) {
            dispatch(new ParseDistrictCities($this->service, $item, $url));
        });
    }
}
