<?php


namespace App\Console\Commands;

use App\Services\Geolocation\Jobs\GeolocateCity;
use Illuminate\Console\Command;

/**
 * Class ImportCitiesGeolocation
 * @package App\Commands
 */
class ImportCitiesGeolocation extends Command
{
    /**
     * {@inheritdoc}
     */
    protected $signature = 'data:geocode';

    /**
     * {@inheritdoc}
     */
    protected $name = 'Find and store coordinates for every city';

    /**
     * @var \App\Contracts\GeolocationContract
     */
    protected $service;

    /**
     * ImportCitiesGeolocation constructor.
     *
     * @param \App\Contracts\GeolocationContract $service
     */
    public function __construct(\App\Contracts\GeolocationContract $service)
    {
        parent::__construct();
        $this->service = $service;
    }

    /**
     * Import all cities coordinates into database.
     *
     * @return void
     */
    public function handle(): void
    {
        $this->service->getCities()->each(function ($city) {
            $this->output->writeln(__('parse.city.geolocate', ['name' => $city->name]));
            dispatch(new GeolocateCity($this->service, $city));
        });
    }
}
