<?php

namespace App\Contracts;

/**
 * Interface Contract
 * @package App\Contracts
 */
interface Contract
{
    /**
     * Find all items.
     *
     * @param array $columns
     * @return \Illuminate\Support\Collection
     */
    public function all(array $columns = ['*']);

    /**
     * Find one item by primary key.
     *
     * @param int $id
     * @param array $columns
     * @return mixed
     */
    public function find($id, array $columns = ['*']);

    /**
     * Save item in database.
     *
     * @param array $attributes
     * @param array $translations
     *
     * @return mixed
     */
    public function store(array $attributes = [], array $translations = []);

    /**
     * Save or update item in database.
     *
     * @param array $find
     * @param array $attributes
     * @param array $translations
     * @return mixed
     */
    public function updateOrStore(array $find = [], array $attributes = [], array $translations = []);

}
