<?php

namespace App\Models\Regions;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use KoenHoeijmakers\LaravelTranslatable\HasTranslations;

/**
 * Class Region
 * @package App\Models\Regions
 *
 * @property int $id
 * @property string $name
 * @property string $alias
 *
 * @property \App\Models\Regions\District[]|\Illuminate\Database\Eloquent\Collection $districts
 */
class Region extends Model
{
    use HasTranslations;

    /**
     * {@inheritdoc}
     */
    protected $translatable = ['name'];

    /**
     * {@inheritdoc}
     */
    protected $fillable = ['name'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function districts(): HasMany
    {
        return $this->hasMany(District::class);
    }
}
