<?php

namespace App\Services\Regions\Components;

use Goutte\Client as HttpClient;
use Symfony\Component\DomCrawler\Crawler;

/**
 * Class Client
 * @package App\Services\Regions\Components
 */
class Client
{
    /**
     * @var string Base parsing URL.
     */
    protected $baseUrl;

    /**
     * @var \Goutte\Client Crawler client.
     */
    protected $client;

    /**
     * HttpClient constructor.
     * @param string $baseUrl
     */
    public function __construct(string $baseUrl)
    {
        $this->baseUrl = $baseUrl;
        $this->client = new HttpClient();
    }

    /**
     * Create URL for region by alias.
     *
     * @param string $alias
     * @return string
     */
    public function makeRegionUrl(string $alias): string
    {
        return '/kraj/' . $alias . '.html';
    }

    /**
     * Load page.
     *
     * @param string $url
     * @param array|null $options
     * @return \Symfony\Component\DomCrawler\Crawler
     */
    public function get(string $url, ?array $options = []): Crawler
    {
        return $this->client->request('GET', $this->makeUrl($url), $options);
    }


    /**
     * Create valid URL.
     *
     * @param string $url
     * @return string
     */
    protected function makeUrl(string $url): string
    {
        return (0 === stripos($url, 'http')) ? $url : ($this->baseUrl . $url);
    }

}
