<?php


namespace App\Services\Regions\Jobs;

use App\Contracts\RegionParserContract;
use Illuminate\Bus\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

/**
 * Class ParseCity
 * @package App\Services\Regions\Jobs
 */
class ParseCity
{
    use Dispatchable, InteractsWithQueue, SerializesModels, Queueable;

    /**
     * @var \App\Contracts\RegionParserContract $service
     */
    private $service;

    /**
     * @var \App\Models\Regions\City
     */
    private $city;

    /**
     * @var string
     */
    private $url;

    /**
     * ParseDistrictCities constructor.
     *
     * @param \App\Contracts\RegionParserContract $service
     * @param \App\Models\Regions\City $city
     * @param string $url
     */
    public function __construct(RegionParserContract $service, $city, $url)
    {
        $this->service = $service;
        $this->city = $city;
        $this->url = $url;
    }

    /**
     * Parse city.
     */
    public function handle(): void
    {
        $this->service->parseCity($this->url, $this->city);
    }
}
