<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

/**
 * Class ModelServiceProvider
 * @package App\Providers
 */
class ModelServiceProvider extends ServiceProvider
{
    /**
     * {@inheritdoc}
     */
    public function register(): void
    {
        $this->app->bind(\App\Contracts\RegionContract::class, \App\Repositories\RegionRepository::class);
        $this->app->bind(\App\Contracts\DistrictContract::class, \App\Repositories\DistrictRepository::class);
        $this->app->bind(\App\Contracts\CityContract::class, \App\Repositories\CityRepository::class);

    }
}
