<?php


namespace App\Services\Regions\Jobs;

use App\Contracts\RegionParserContract;
use Illuminate\Bus\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

/**
 * Class ParseDistrictCities
 * @package App\Services\Regions\Jobs
 */
class ParseDistrictCities
{
    use Dispatchable, InteractsWithQueue, SerializesModels, Queueable;

    /**
     * @var \App\Contracts\RegionParserContract $service
     */
    private $service;

    /**
     * @var \App\Models\Regions\District
     */
    private $district;

    /**
     * @var string
     */
    private $url;

    /**
     * ParseDistrictCities constructor.
     *
     * @param \App\Contracts\RegionParserContract $service
     * @param \App\Models\Regions\District $district
     * @param string $url
     */
    public function __construct(RegionParserContract $service, $district, $url)
    {
        $this->service = $service;
        $this->district = $district;
        $this->url = $url;
    }

    /**
     * Parse cities.
     */
    public function handle(): void
    {
        $this->service->parseDistrict($this->url, $this->district)->each(function ($item, $url) {
            dispatch(new ParseCity($this->service, $item, $url));
        });

    }
}
