<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class CreateRegionsTable
 */
class CreateRegionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('regions', static function (Blueprint $table) {
            $table->increments('id');
            $table->string('alias', 2);
            $table->timestamps();
            $table->unique('alias');
        });
        Schema::create('region_translations', static function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('region_id');
            $table->string('locale');
            $table->string('name');
            $table->timestamps();

            $table->unique(['locale', 'region_id']);
            $table->foreign('region_id')->references('id')->on('regions')
                ->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('region_translations');
        Schema::dropIfExists('regions');
    }
}
